VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DLXOCX32.OCX"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   6690
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6135
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   6690
   ScaleWidth      =   6135
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   5040
      TabIndex        =   10
      Top             =   5880
      Width           =   855
   End
   Begin VB.Frame Frame2 
      Caption         =   "Timing Mode"
      Height          =   975
      Left            =   480
      TabIndex        =   7
      Top             =   3240
      Width           =   1815
      Begin VB.OptionButton Option3 
         Caption         =   "Rate Mode"
         Height          =   255
         Left            =   240
         TabIndex        =   9
         ToolTipText     =   "One Sample per Clock Tic"
         Top             =   600
         Value           =   -1  'True
         Width           =   1095
      End
      Begin VB.OptionButton optBurst 
         Caption         =   "Burst Mode"
         Height          =   255
         Left            =   240
         TabIndex        =   8
         ToolTipText     =   "One Scan of all Channels per Clock Tic"
         Top             =   240
         Width           =   1335
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Select Units"
      Height          =   975
      Left            =   480
      TabIndex        =   4
      Top             =   2040
      Width           =   1815
      Begin VB.OptionButton Option2 
         Caption         =   "Fahrenheit"
         Height          =   195
         Left            =   240
         TabIndex        =   6
         Top             =   600
         Width           =   1215
      End
      Begin VB.OptionButton optC 
         Caption         =   "Celsius"
         Height          =   255
         Left            =   240
         TabIndex        =   5
         Top             =   240
         Value           =   -1  'True
         Width           =   1095
      End
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   5160
      Top             =   600
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.ListBox List1 
      Height          =   3180
      Left            =   2880
      TabIndex        =   2
      Top             =   1080
      Width           =   1215
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start Paced Acquisition"
      Enabled         =   0   'False
      Height          =   375
      Left            =   480
      TabIndex        =   1
      Top             =   1320
      Width           =   2055
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Open Driver and Init"
      Height          =   375
      Left            =   480
      TabIndex        =   0
      Top             =   720
      Width           =   2055
   End
   Begin VB.Label Label2 
      Caption         =   $"frmMain.frx":030A
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   855
      Left            =   480
      TabIndex        =   12
      Top             =   5400
      Width           =   3975
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   360
      Left            =   360
      TabIndex        =   11
      Top             =   120
      Width           =   1845
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H8000000E&
      Caption         =   "Label1"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   615
      Left            =   480
      TabIndex        =   3
      Top             =   4560
      Width           =   3975
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim NumberofSamples As Long
'  DAS-TC/B has special gain codes for control of T/C type, averaging,
'   CJC on/off, and C or F reporting.
'   See the Analog Input Gain Codes section of the 'Using the DAS-TC/B
'   With DriverLINX ' document located in c:\driverlinx4\docs\notes\kdastc.pdf
'
'     -32768 + 5 = B Type T/C Sensor
'     -32768 + 6 = E Type T/C Sensor
'     -32768 + 7 = J Type T/C Sensor
'     -32768 + 8 = K Type T/C Sensor
'     -32768 + 9 = R Type T/C Sensor
'     -32768 + 10 = S Type T/C Sensor
'     -32768 + 11 = T Type T/C Sensor
'     -32768 + 13 = N Type T/C Sensor
'
'     1x2^13 = 8192 = CJC On
'     0x2^13 = 0 = CJC Off
'
'     1x2^14 = 16384 = report in deg F
'     0x2^14 = 0 = report in deg C
'
'     n*2^6 = n*64 = average n measurements with each reported reading

Private Sub cmdExit_Click()
Form_Unload (0)
End
End Sub

Private Sub cmdInit_Click()
    With SR
    .Req_DLL_name = "kdastc$"
    .Req_device = 0
    .Req_mode = DL_OTHER
    .Req_op = DL_INITIALIZE
    .Req_subsystem = DL_DEVICE
    .Refresh
    End With
    
    If SR.Res_result = DL_NoErr Then
    ' enable sample button
    cmdStart.Enabled = True
    cmdInit.Enabled = False
    lblStatus.Caption = "Initialized with " & SR.Message
    Else
    ' report on error
    lblStatus.Caption = SR.Message
    End If
    Form1.SetFocus  ' return focus to the application
End Sub

Private Sub cmdStart_Click()
Dim Units As Integer
NumberofSamples = 16
List1.Clear  ' clear old data from list box
    With SR
    .Req_op = DL_START
    .Req_mode = DL_INTERRUPT
    .Req_subsystem = DL_AI
    ' specify the start and stop types
    .Evt_Str_type = DL_COMMAND
    .Evt_Stp_type = DL_TCEVENT
    ' specify the properties that will pace our task
    .Evt_Tim_type = DL_RATEEVENT
    .Evt_Tim_rateChannel = DL_DEFAULTTIMER
    .Evt_Tim_rateClock = DL_INTERNAL1
    .Evt_Tim_rateGate = DL_NOCONNECT
    ' ratePeriod is how fast to go.....can be no faster than 2 Hz (0.5sec)
    ' can be no slower than 27.3 minutes
    .Evt_Tim_ratePeriod = .DLSecs2Tics(.Evt_Tim_rateChannel, 1) 'set for 1Hz
    If optBurst.Value = True Then
    ' set up burst mode
    .Evt_Tim_rateMode = DL_BURSTGEN
    .Evt_Tim_ratePulses = 16  ' must equal number of channels in the scan
    .Evt_Tim_rateOnCount = .DLSecs2Tics(.Evt_Tim_rateChannel, 0.04) 'set for 24Hz
    ' onCount is the speed of burst...can be no faster than 25 Hz
    Else
    ' normal rate mode
    .Evt_Tim_rateMode = DL_RATEGEN
    .Evt_Tim_ratePulses = 0
    .Evt_Tim_rateOnCount = 0
    End If
    ' specify the channels
    .Sel_chan_N = 2  ' does NOT mean 2.  Means start and stop channels
    .Sel_chan_start = 0
    .Sel_chan_stop = 15
    ' the gain code controls TC type, CJC, Units, averaging
    ' start gain code applies to first channel
    ' stop gain code applies to all others in the start/stop range
    
    If (optC.Value = True) Then
      Units = 0  ' deg C
      Else
      Units = 16384  ' deg F
    End If
    
    .Sel_chan_startGainCode = -32768 + 7 + 8192 + Units + (2 * 64)
                             ' type J + CJC + C or F + avg 1 per report
    .Sel_chan_stopGainCode = -32768 + 7 + 8192 + Units + (2 * 64)
    
    ' specify the buffering
    .Sel_buf_N = 1
    .Sel_buf_samples = NumberofSamples
    .Sel_buf_notify = DL_NOTIFY  ' send buffer filled messages
    .Sel_chan_format = DL_tNATIVE
    ' start the task
    '.Req_op_edit = True
    '.Refresh
    .Refresh
    End With
    
    If SR.Res_result = DL_NoErr Then
    '
    lblStatus.Caption = "AI task started with " & SR.Message & _
                        "...please be patient, I am a very slow board"
    Else
    lblStatus.Caption = SR.Message
    End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
' unload the driver
SR.Req_DLL_name = ""
End Sub

Private Sub SR_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)
Dim dummy As Single
Dim Data(100) As Single
Dim i As Integer

dummy = SR.VBArrayBufferConvert(bufIndex, 0, NumberofSamples, Data, DL_tSINGLE, 0, 0)
For i = 0 To NumberofSamples - 1
List1.AddItem Str(Data(i))
Next i

lblStatus.Caption = "data are here"
End Sub
